#!/usr/bin/env python
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

bridgingEtbaConfigPath = "bridging/etba/config"

# Import used to generate dependency on Launcher
# pylint: disable=import-error
# pylint: disable=unused-import
import LauncherPlugin.Launcher

def Plugin( context ):
   etbaConfig = context.lookup( bridgingEtbaConfigPath )

   # Etba is launched by Launcher inside vEOS-lab and cEOS-lab.
   # We also need a launcher configuration in namespace duts,
   # since the trace cli only allows you to trace an agent that has a
   # launcher config.
   agentName = "Etba"
   agentCfg = { "name" : agentName,
                "exe" : "/usr/bin/Etba",
                "argv" : [ "--inNamespace" ],
                "oomScoreAdj" : -300, # see AID3426
                "heartbeatPeriod" : 30,
                "startupGracePeriod" : 300,
                "runnability": [ { "entity": etbaConfig,
                                   "qualAttr": 'extTapDevice' } ]

              }

   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )
