#!/usr/bin/env python
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Import used to generate dependency on Launcher
# pylint: disable=import-error
# pylint: disable=unused-import
import LauncherPlugin.Launcher

def Plugin( context ):
   eoamHwStatus = context.lookup( "eoam/hardware/status/global" )
   eoamConfig = context.lookup( "eoam/config" )

   reflectorConfig = context.lookup( "reflector/config" )
   reflectorHwCapabilities = context.lookup( "reflector/hardware/capabilities" )

   # Agent runs only if one or more of the following are true:
   #  Eoam is supported and an eoam config exists
   #  Reflector is supported and an interface config exists
   runnability = [ ( { "entity" : eoamHwStatus,
                       "qualAttr" : "eoamSupported" },
                     { "entity" : eoamConfig,
                       "qualAttr" : "eoamProfile" } ),
                   ( { "entity": reflectorHwCapabilities,
                       "qualAttr": "directionSupported" },
                     { "entity": reflectorHwCapabilities,
                       "qualAttr": "macActionSupported" },
                     { "entity": reflectorConfig,
                       "qualAttr" : "interfaceConfig" } ) ]
   agentCfg = { "name": "Eoam",
                "exe": "/usr/bin/Eoam",
                "argv": [],
                "heartbeatPeriod": 30,
                "runnability" : runnability }

   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )
