#!/usr/bin/env python
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

def getRunnability( context, pllName ):
   pllConfigPath = 'hardware/pllClockMux/config/%s' % pllName

   entity = context.lookup
   ptpConfig = entity( 'ptp/config' )
   timestampingStatus = entity( 'interface/status/timestamping' )
   mirroringStatus = entity( 'mirroring/status' )
   qosStatus = entity( 'qos/status' )
   latencyStatus = entity( 'hardware/lanz/latency' )

   anyPlls = { 'qualPath': pllConfigPath + '.pllCfg/%*' }
   anyDefaultPlls = { 'qualPath': pllConfigPath + '.defaultPll/%*' }
   ptpEnabled = { 'entity': ptpConfig, 'qualAttr': 'ptpMode' }
   timestampingEnabled = { 'entity': timestampingStatus, 'qualAttr': 'numEnabled' }
   greTimestampingEnabled = { 'entity' : mirroringStatus,
                              'qualAttr': 'greTimestampingEnabled' }
   ecnDelayEnabled = { 'entity': qosStatus, 'qualAttr': 'ecnDelayThreshold' }
   txLatencyEnabled = { 'entity' : latencyStatus,
                        'qualAttr' : 'enabled' }

   return ( anyPlls, [ anyDefaultPlls,
                       ptpEnabled,
                       timestampingEnabled,
                       greTimestampingEnabled,
                       ecnDelayEnabled,
                       txLatencyEnabled ] )

def commonInit( context, pllName, agentName ):
   systemAgentName = agentName
   systemAgentCfg = { "name": systemAgentName,
                      "exe": "/usr/bin/%s" % agentName,
                      "argv": [],
                      "heartbeatPeriod": 30,
                      "runnability": getRunnability( context, pllName ) }
   role = { 'rpr' : context.activeSupervisorRoleName,
            'sso' : context.allSupervisorsRoleName }
   context.agentConfigIs( role, systemAgentCfg )
