#!/usr/bin/env python
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Import used to generate dependency on Launcher
# pylint: disable=import-error
# pylint: disable=unused-import
import LauncherPlugin.Launcher
import Toggles.Dot1xToggleLib as Dot1xToggle

def Plugin( context ):
   config = context.lookup( "dot1x/config" )
   status = context.lookup( "dot1x/status" )
   hwCapabilities = context.lookup( "bridging/hwcapabilities" )

   agentName = "Dot1x"
   agentCfg = { "name" : agentName,
                "exe" : "/usr/bin/Dot1x",
                "argv" : [],
                "heartbeatPeriod" : 30,
                "runnability" : [ { "entity" : config,
                                    "qualAttr" : "dot1xEnabled" },
                                  { "entity" : status,
                                    "qualAttr" : "dot1xEnabled" },
                                  { "entity" : status,
                                    "qualAttr" : "dot1xIntfStatus" },
                                  { "entity" : hwCapabilities,
                                    "qualAttr" : "macBasedVlanSupported" } ]
              }
   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )

   # ********* Dot1x Web Agent *************/*

   if Dot1xToggle.toggleDot1xWebAuthEnabled():

      webAgentStatus = context.lookup( "dot1x/webAgentStatus" )

      # only depend captive portal configuration and status to start dot1x web agent
      # it is possible that Dot1xWeb agent may run before Dot1x agent starts
      webAgentRunnability = [ { "entity": config, "qualAttr": "captivePortal" },
                              { "entity": webAgentStatus, "qualAttr": "running" } ]
      dot1xWebAgentCfg = { "name": "Dot1xWeb",
                           "exe": "/usr/bin/Dot1xWeb",
                           "argv": [],
                           "heartbeatPeriod": 30,
                           "runnability": webAgentRunnability }
      context.agentConfigIs( roleName, dot1xWebAgentCfg )
