#!/usr/bin/env python
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Import used to generate dependency on Launcher
# pylint: disable=import-error
# pylint: disable=unused-import
import LauncherPlugin.Launcher

def Plugin( context ):
   config = context.lookup( 'ip/helper/dhcprelay/config' )
   status = context.lookup( 'ip/helper/dhcprelay/status' )
   snoopingConfigV4 = context.lookup( 'bridging/dhcpsnooping/config' )

   agentName = 'DhcpRelay'
   agentCfg = { 'name' : agentName,
                'exe' : '/usr/bin/DhcpRelay',
                'argv' : [],
                'heartbeatPeriod' : 30,
                'runnability': [ { 'entity' : config,
                                   'qualAttr' : 'intfConfig' },
                                 { 'entity' : config,
                                   'qualAttr' : 'alwaysOn' },
                                 { 'entity' : config,
                                   'qualAttr' : 'dhcpRelayGlobalModeConfig' },
                                 { 'entity' : snoopingConfigV4,
                                   'qualAttr' : 'bridging' },
                                 { 'entity' : status,
                                   'qualAttr' : 'runControl' } ] }

   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )
