#!/usr/bin/env python
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Import used to generate dependency on Launcher
# pylint: disable=import-error
# pylint: disable=unused-import
import LauncherPlugin.Launcher

def Plugin( context ):
   runnability = [ { "qualPath" :
                        "hardware/phyChip/config/ac400/slice/%sliceId.chipConfig/%*",
                   } ]
   sliceAgentCfg = { "name" : "Denali",
                     "exe" : "/usr/bin/Denali",
                     "argv" : [ "--sliceId=%(sliceId)s" ],
                     "heartbeatPeriod" : 30,
                     "runnability" : runnability }

   # Agent only runs on active supervisor
   context.agentConfigIs( context.activeSupervisorRoleName, sliceAgentCfg )
