# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Import used to generate dependency on Launcher
# pylint: disable=import-error
# pylint: disable=unused-import
import LauncherPlugin.Launcher

def Plugin( context ):
   agentStatus = context.lookup( 'te/cspf/agentStatus' )
   # Cspf agent should run only when at least one of it's
   # client is present
   agentName = 'Cspf'
   agentCfg = {
      'name' : agentName,
      'exe' : '/usr/bin/Cspf',
      'argv' : [],
      'heartbeatPeriod' : 30,
      'runnability' : [ { 'qualPath' : 'te/cspf/client/%*' },
                        { 'entity' : agentStatus, 'qualAttr' : 'agentEnabled' }
      ]
   }
   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )
