#!/usr/bin/env python
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

ctrlDebugDir = 'controller/debug'
mgmtCtrlDebugDir = 'mgmt/controller/debug'

# Import used to generate dependency on Launcher
# pylint: disable=import-error
# pylint: disable=unused-import
import LauncherPlugin.Launcher

def Plugin( context ):
   serverCfg = context.lookup( ctrlDebugDir + "/config" )
   clientCfg = context.lookup( mgmtCtrlDebugDir + "/config" )
   defaultClusterStatus = context.lookup(
      "controller/cluster/statusDir.status/default" )

   serverSysdbCfg = {
      "name": "ControllerDebugServer",
      "exe": "/usr/bin/ControllerDebugServer",
      "argv": [],
      "heartbeatPeriod": 30,
      "runnability" : [ ( { 'entity' : serverCfg,
                            'qualAttr' : 'enabled' },
                          { 'entity' : defaultClusterStatus,
                            'qualAttr' : 'isStandaloneOrLeader' } ) ]
   }

   clientSysdbCfg = {
      "name": "ControllerDebugClient",
      "exe": "/usr/bin/ControllerDebugClient",
      "argv": [],
      "heartbeatPeriod": 30,
      "runnability": [ { "entity": clientCfg, "qualAttr": "enabled" } ] }

   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, serverSysdbCfg )
   context.agentConfigIs( roleName, clientSysdbCfg )
