# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Import used to generate dependency on Launcher
# pylint: disable=import-error
# pylint: disable=unused-import
import LauncherPlugin.Launcher

def Plugin( context ):
   config = context.lookup( 'connectivityMonitor/config' )
   status = context.lookup( 'connectivityMonitor/status' )

   agentName = 'ConnectivityMonitor'
   # Runnability depends on config.enabled and status.enabled so that the agent can
   # clean itself up once it has been disabled.
   agentRunnability = [ { 'entity': config,
                          'qualAttr': 'enabled' },
                        { 'entity': status,
                          'qualAttr': 'enabled' } ]

   agentCfg = { 'name': agentName,
                'exe': '/usr/bin/ConnectivityMonitor',
                'argv': [],
                'heartbeatPeriod': 30,
                "startupGracePeriod": 900,
                'runnability': agentRunnability,
              }

   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )
