#!/usr/bin/env python
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Import used to generate dependency on Launcher
# pylint: disable=import-error
# pylint: disable=unused-import
import LauncherPlugin.Launcher

def Plugin( context ):
   # CliRelay agent on CVX start running only if there is a client e.g.
   # BugAlert is enabled that need to use CliRelay
   # We should start CliRelaySwitchAgent on switch when CliRelay on CVX
   # is running.
   # CliRelay on CVX publish cliRelay/version1/fromCvx/commandDir
   # so it should appear on switch when SCS is running on CVX.
   runnability = [ { 'qualPath' :
                     'cliRelay/version1/fromCvx/commandDir' } ]
   agentName = "CliRelaySwitchAgent"
   agentCfg = { "name": agentName,
                "exe": "/usr/bin/CliRelaySwitchAgent",
                "argv": [],
                "heartbeatPeriod": 120,
                "runnability" : runnability
              }
   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )
