#!/usr/bin/env python
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Import used to generate dependency on Launcher
# pylint: disable=import-error
# pylint: disable=unused-import
import LauncherPlugin.Launcher

def Plugin( context ):
   cliRelayClients = context.lookup( "cliRelay/clients" )

   cliRelayAgentStatus = context.lookup( "cliRelay/serviceAgentStatus" )
   controllerdbStatus = context.lookup( 'controller/status' )
   defaultClusterStatus = context.lookup(
      "controller/cluster/statusDir.status/default" )

   # Run CliRelay agent if controller is configured AND
   # there is at least one client enabled that need to use
   # CliRelay
   agentName = "CliRelay"
   agentCfg = { "name": agentName,
                "exe": "/usr/bin/CliRelay",
                "argv": [],
                "heartbeatPeriod": 120,
                "runnability" : [ ( { 'entity' : controllerdbStatus,
                                       'qualAttr' : 'enabled' },
                                    { 'entity' : cliRelayClients,
                                       'qualAttr' : 'entityPtr' },
                                    { 'entity'   : defaultClusterStatus,
                                      'qualAttr' : 'isStandaloneOrLeader' } ),
                                  ( { 'entity' : controllerdbStatus,
                                       'qualAttr' : 'enabled' },
                                    { 'entity' : cliRelayAgentStatus,
                                       'qualAttr' : 'agentNotCleanedUp' } ) ]
              }

   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )
