#!/usr/bin/env python
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Import used to generate dependency on Launcher
# pylint: disable=import-error
# pylint: disable=unused-import
import LauncherPlugin.Launcher

def Plugin( context ):
   config = context.lookup( "cfm/config" )
   status = context.lookup( "cfm/status" )
   aleConfig = context.lookup( "cfm/aleConfig" )
   aleStatus = context.lookup( "cfm/aleStatus" )

   runnabilityA = { 'entity' : config,
                    'qualAttr' : 'mdConfig' }
   runnabilityB = { 'entity' : status,
                    'qualAttr' : 'mdStatus' }
   runnabilityC = { 'entity' : aleConfig,
                    'qualAttr' : 'mdConfig' }
   runnabilityD = { 'entity' : aleStatus,
                    'qualAttr' : 'mdStatus' }

   runnability = [ runnabilityA, runnabilityB,
                   runnabilityC, runnabilityD ] # A || B || C || D

   roleName = context.activeSupervisorRoleName
   agentName = 'CfmAgent'
   exeName = '/usr/bin/CfmAgent'
   agentCfg = { "name" : agentName,
                "exe" : exeName,
                "argv" : [],
                "heartbeatPeriod" : 30,
                "runnability" : runnability }

   context.agentConfigIs( roleName, agentCfg )
