#!/usr/bin/env python
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pylint: disable-msg=F0401
import LauncherPlugin.HttpService

# Import used to generate dependency on Launcher
# pylint: disable=import-error
# pylint: disable=unused-import
import LauncherPlugin.Launcher

def Plugin( context ):
   # pylint: disable-msg=F0401
   capiConfig = context.lookup(
      LauncherPlugin.HttpService.configPath( "http-commands" ) )
   httpServerStatus = context.lookup( 'mgmt/httpserver/status' )
   agentCfg = { "name": "CapiApp",
                "exe": "/usr/bin/CapiApp",
                "argv": [ "--ini", "/etc/uwsgi/CapiApp.ini" ],
                "heartbeatPeriod": 90,
                'runnability': [ { 'entity'   : capiConfig,
                                   'qualAttr' : 'enabled' },
                                 { 'entity'   : httpServerStatus,
                                   'qualAttr' : 'defaultServiceEnabled' } ] }
   context.agentConfigIs( context.activeSupervisorRoleName, agentCfg )


