#!/usr/bin/env python
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Import used to generate dependency on Launcher
# pylint: disable=import-error
# pylint: disable=unused-import
import LauncherPlugin.Launcher

def Plugin( context ):
   agentName = "BugAlert"
   bugAlertConfig = context.lookup( "bugalert/config" )
   bugAlertStatus = context.lookup( "bugalert/status" )
   controllerdbStatus = context.lookup( 'controller/status' )
   defaultClusterStatus = context.lookup(
      "controller/cluster/statusDir.status/default" )

   agentCfg = { "name": agentName,
                "exe": "/usr/bin/BugAlert",
                "argv": [],
                "heartbeatPeriod": 120,

                # With more than one runnability, the agent is started if any
                # of them evaluates to true and it is terminated only when all
                # of them evaluates to false.
                "runnability": [ ( { "entity" : bugAlertConfig,
                                   "qualAttr": "enabled" },
                                 { "entity" : controllerdbStatus,
                                   "qualAttr" : "enabled" },
                                 { "entity" : defaultClusterStatus,
                                  "qualAttr" : "isStandaloneOrLeader" } ),
                                 { "entity" : bugAlertStatus,
                                   "qualAttr" : "agentNotCleanedUp" } ]
                }

   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )
