#!/usr/bin/env python
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Import used to generate dependency on Launcher
# pylint: disable=import-error
# pylint: disable=unused-import
import LauncherPlugin.Launcher

def Plugin( context ):
   config = context.lookup( 'routing/bmp/config' )

   agentCfg = { 'name': 'Bmp',
                'exe': '/usr/bin/Bmp',
                'argv': [],
                'heartbeatPeriod': 30,
                'startupGracePeriod': 30,
                'runnability' : [ { 'entity' : config,
                                    'qualAttr' : 'bmpActivate' },
                                  { 'entity' : config,
                                    'qualAttr' : 'bmpStation' } ] }
   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )
