#!/usr/bin/env python
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Import used to generate dependency on Launcher
# pylint: disable=import-error
# pylint: disable=unused-import
import LauncherPlugin.Launcher
from CEosHelper import isCeos

def Plugin( context ):

   # Bfd runs unconditionally on the active supervisor of non-cEOS devices.
   if isCeos():
      return

   agentCfg = { "name": "Bfd",
                "exe": "/usr/bin/Bfd",
                "argv": [],
                "oomScoreAdj" : -150, #  see AID3426
                "heartbeatPeriod": 63 }

   roleName = { 'sso' : context.allSupervisorsRoleName,
                'rpr' : context.activeSupervisorRoleName }
   context.agentConfigIs( roleName, agentCfg )

