# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Import used to generate dependency on Launcher
# pylint: disable=import-error
# pylint: disable=unused-import
import LauncherPlugin.Launcher

# TODO: Remove dependency once there is an explicit dependency on Sfe-lib rpm
# pkgdeps: import LauncherPlugin.Sfe
# pkgdeps: import McastCommonAgent

def Plugin( context ):
   bessAgentStatus = context.lookup( 'bess/agentstatus' )

   runnability = [ { 'entity' : bessAgentStatus,
                     'qualAttr' : 'v4Enabled' },
                   { 'entity' : bessAgentStatus,
                     'qualAttr' : 'v6Enabled' } ]

   agentCfg = {
      "name" : "BessMgr",
      "exe" : "/usr/bin/BessMgr",
      "argv" : [],
      "heartbeatPeriod" : 30,
      "runnability" : runnability
   }
   role = { 'rpr' : context.activeSupervisorRoleName,
            'sso' : context.allSupervisorsRoleName }

   context.agentConfigIs( role, agentCfg )
