# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps : import LauncherPlugin.Launcher

import Toggles.ControllerAclToggleLib

def Plugin( context ):
   if not Toggles.ControllerAclToggleLib.toggleControllerAclEnabled():
      return

   controllerCfg = context.lookup( 'mgmt/controller/config' )
   aclClientSts = context.lookup( 'mgmt/controller/aclClient/status' )
   agentCfg = {
         "name" : "AclCvxClient",
         "exe" : "/usr/bin/AclCvxClient",
         "argv" : [],
         "heartbeatPeriod" : 120,
         'runnability' : [ { 'entity' : controllerCfg, 'qualAttr' : "enabled" },
                           { 'entity' : aclClientSts, 'qualAttr' : "enabled" } ]
         }
   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )
