# Copyright (c) 2015 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
from IpLibConsts import DEFAULT_VRF
from CliPlugin.RoutingCommon import parseKernelIpRouteShow

def kernelIpRoutes( vrfName=DEFAULT_VRF, ipv6=False, protocol=None,
                    connectedRoute=False, protoUnset=False, getMetric=False,
                    dut=None, table="main", proto="all" ):
   cmd = ""
   if vrfName != DEFAULT_VRF:
      nsName = "ns-%s" % vrfName
      cmd = "ip netns exec %s " % nsName
   cmd += "ip %s route show table %s proto %s" % \
               ( ( '-6' if ipv6 else '-4' ), table, proto )
   if dut:
      # To support ptest variants
      cmd = 'bash sudo ' + cmd
      output = dut.showCmdIs( cmd )
   else:
      output = Tac.run( cmd.split(), stdout=Tac.CAPTURE, asRoot=True )
      output = output.split( "\n" )
   return parseKernelIpRouteShow( output, ipv6, protocol, connectedRoute,
                                  protoUnset, getMetric)
