# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import RoutingIntfUtils
import Tac

SubIntfIdType = Tac.Type( "Arnet::SubIntfId" )

def intfSupportsIpLocking( intfName ):
   return ( not RoutingIntfUtils.isManagement( intfName ) and
            intfName.startswith( ( 'Ethernet', ) ) and
            not SubIntfIdType.isSubIntfId( intfName )
          )
