#!/usr/bin/env python
# Copyright (c) 2013 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Intf.IntfRange as IntfRange
import LazyMount

hwCapabilities = None

#-------------------------------------------------------------------------------
# Register the VxlanIntf class as able to participate in interface ranges.
#-------------------------------------------------------------------------------
VxlanAutoIntfType = IntfRange.GenericRangeIntfType(
   lambda: ( 1, hwCapabilities.vxlanMaxTunnelInterfacesSupported ),
   "Vxlan", "Vx", "Vxlan Tunnel Interface" )
intfOptions = IntfRange.IntfOptions( ipSupport=False, routingProtoSupport=False )
IntfRange.registerIntfType( VxlanAutoIntfType, intfOptions )

def Plugin( entityManager ):
   global hwCapabilities
   hwCapabilities = LazyMount.mount(
         entityManager, 'bridging/hwcapabilities',
         'Bridging::HwCapabilities', 'r' )
