# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Intf.IntfRange as IntfRange
import LazyMount
import itertools

speedGroupStatusSliceDir = None

class HardwareGroup( object ):
   def __init__( self, collection, name, helpText, helpdesc, collectionVersion ):
      self.name = name
      # Define group type
      self.type = IntfRange.AutoIntfType( collectionFunc=collection,
                                          tagLong=name,
                                          tagShort=name,
                                          helpText=helpText,
                                          helpdesc=helpdesc,
                                          collectionVersionFunc=collectionVersion )
      # Register group type in order to use intfTypeFromName()
      IntfRange.registerGroupType( self.type )

class SpeedGroup( HardwareGroup ):
   def __init__( self ):
      super( SpeedGroup, self ).__init__( self.collection,
                                          'speed-group',
                                          'Hardware speed group',
                                          [ 'Group ID number' ],
                                          self.collectionVersion )

   def collection( self ):
      def _iterGroup( statusDir ):
         return itertools.chain( *( ( self.name + k for k in d.group ) for d in
                                    statusDir.itervalues() ) )
      return itertools.chain( *( _iterGroup( d ) for d in
                                 speedGroupStatusSliceDir.itervalues() ) )

   def collectionVersion( self ):
      versionList = [ speedGroupStatusSliceDir.entityPtr.version() ]
      for subSliceDir in speedGroupStatusSliceDir.itervalues():
         for speedGroupStatusDir in subSliceDir.itervalues():
            versionList.append( speedGroupStatusDir.group.version() )
      return versionList

SpeedGroupType = SpeedGroup()

def Plugin( em ):
   global speedGroupStatusSliceDir
   speedGroupStatusSliceDir = LazyMount.mount( em,
         "interface/archer/status/eth/phy/speedgroup/slice",
         "Tac::Dir", "ri" )
