# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Intf.IntfRange as IntfRange
import itertools
import LazyMount

logicalPortStatusSliceDir = None

class HardwareGroup( object ):
   def __init__( self, collectionFunc, name, helpText, helpdesc,
                 collectionVersionFunc ):
      self.name = name
      # Define group type
      self.type = IntfRange.AutoIntfType(
         collectionFunc=collectionFunc,
         tagLong=name,
         tagShort=name,
         helpText=helpText,
         helpdesc=helpdesc,
         collectionVersionFunc=collectionVersionFunc )
      # Register group type in order to use intfTypeFromName()
      IntfRange.registerGroupType( self.type )

class LogicalPortPool( HardwareGroup ):
   def __init__( self ):
      super( LogicalPortPool, self ).__init__( self.collectionFunc,
                                               'pool',
                                               'Logical port pool',
                                               [ 'Pool ID number' ],
                                               self.collectionVersionFunc )

   def collectionFunc( self ):
      def _iterGroup( statusDir ):
         return itertools.chain.from_iterable(
                                   ( self.name + k for k in d.poolStatus )
                                   for d in statusDir.itervalues() )
      return itertools.chain.from_iterable(
                                _iterGroup( d )
                                for d in logicalPortStatusSliceDir.itervalues() )

   def collectionVersionFunc( self ):
      versionList = [ logicalPortStatusSliceDir.entityPtr.version() ]
      for subSliceDir in logicalPortStatusSliceDir.itervalues():
         for logicalPortPoolStatusDir in subSliceDir.itervalues():
            versionList.append( logicalPortPoolStatusDir.poolStatus.version() )
      return versionList

LogicalPortPoolType = LogicalPortPool()

def Plugin( em ):
   global logicalPortStatusSliceDir
   logicalPortStatusSliceDir = LazyMount.mount( em,
         "interface/archer/status/eth/phy/logicalport/slice", "Tac::Dir", "ri" )
