#!/usr/bin/env python
# Copyright (c) 2013 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Toggles.IntfToggleLib
from Toggles.EbraToggleLib import togglePortChannelIdIncreaseEnabled
import Intf.IntfRange as IntfRange
import LazyMount
import Tac

hwCapabilities = None
PortChannelNum = Tac.Type( "Lag::PortChannelNum" )
PortChannelNumMin = PortChannelNum.min
PortChannelNumMax = PortChannelNum.max

LimitedChannelNum = Tac.Type( "Lag::LimitedChannelNum" )
PortChannelExtendedMin = LimitedChannelNum.extendedSubMin
PortChannelExtendedMax = LimitedChannelNum.extendedSubMax

SubIntfRangeDetails = Tac.Type( "Interface::SubIntfIdConstants" )
SubExtendedMin = SubIntfRangeDetails.subIntfExtendedIdMin 
SubExtendedMax = SubIntfRangeDetails.subIntfExtendedIdMax 

def portChannelRangeFn( mode ):
   # Allow up to extendedMax while loading startup-config as hwCapabilities
   # is not yet available. If both hwCapabilities and mode are unavailable,
   # restrict to original max.
   if ( ( mode and mode.session_.startupConfig() and
          not mode.session_.guardsEnabled() ) or
        ( hwCapabilities and hwCapabilities.extendedLagIdSupported and
          togglePortChannelIdIncreaseEnabled() ) ):
      return ( PortChannelNum.min, PortChannelNum.extendedMax )
   return ( PortChannelNum.min, PortChannelNum.max )

def portChannelSubRangeFn():
   if hwCapabilities and hwCapabilities.extendedLagIdSupported and \
      togglePortChannelIdIncreaseEnabled():
      return ( PortChannelExtendedMax + 1, PortChannelNum.extendedMax )
   return ( PortChannelExtendedMax + 1, PortChannelNum.max )

# When dynamic ifIndex values are available,
# all port-channels use the extended sub-interface range.
# (Interfaces in the Lag::LimitedChannelNum have static
#  ifIndex values associated with them; beyond that range
#  the ifIndex values are dynamically allocated.)
# When dynamic ifIndex values are not available,
# the range above the Lag::LimitedChannelNum values
# use standard (not extended) subinterface values.
LagRangeInfo = [ IntfRange.SubRangeInfo(
                    lambda: ( PortChannelExtendedMin, PortChannelExtendedMax ),
                    SubExtendedMin, SubExtendedMax ) ]
if Toggles.IntfToggleLib.toggleDynamicIfIndexEnabled():
   LagRangeInfo += [ IntfRange.SubRangeInfo(
                    portChannelSubRangeFn,
                    SubExtendedMin, SubExtendedMax ) ]
else:
   LagRangeInfo += [ IntfRange.SubRangeInfo(
                    portChannelSubRangeFn ) ]


LagAutoIntfType = IntfRange.MultiSubRangeIntfType(
   portChannelRangeFn,
   "Port-Channel", "Po", "Lag interface",
   LagRangeInfo,
   subSupported=True, subIntfGuard=IntfRange.subintfSupportedGuard,
   dynamicRange=True )

intfOptions = IntfRange.IntfOptions( ipSupport=True, routingProtoSupport=True )
IntfRange.registerIntfType( LagAutoIntfType, intfOptions )

def Plugin( entityManager ):
   global hwCapabilities
   hwCapabilities = LazyMount.mount(
                        entityManager, 'bridging/hwcapabilities',
                        'Bridging::HwCapabilities', 'r' )
