# Copyright (c) 2006, 2009, 2010 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Logging
import UtmpDump

# NOTE: This message is repeated in ArnetLog.h
LINEPROTO_UPDOWN = None # Keep pylint happy.
Logging.logD(
   id="LINEPROTO_UPDOWN",
   severity=Logging.logNotice,
   format="Line protocol on Interface %s, changed state to %s",
   explanation="The link-layer connection on the given interface has "
   "come up or down.  "
   "If it is not up, then communication with our link partner is not possible.",
   recommendedAction="If the connection has gone down unexpectedly, check the "
   "physical connection (e.g., cable) between the devices and the configuration of "
   "the link on both ends." )

# Standard log format for clearing counters:
# Mar 12 22:17:43.150: %CLEAR-5-COUNTERS:
#    Clear counter on all interfaces by arastra on vty0 (172.17.10.37)
# Mar 12 22:32:52.591: %CLEAR-5-COUNTERS:
#    Clear counter on interface Vlan1 by arastra on vty0 (172.17.10.37)
#
# Use Logging.logNotice (5) level to match format
CLEAR_COUNTERS = None # So Pylint can see this
Logging.logD(
   id="CLEAR_COUNTERS",
   severity=Logging.logNotice,
   format="Clear %scounters %sby %s on %s (%s)",
   explanation="Counter was cleared by CLI command",
   recommendedAction=Logging.NO_ACTION_REQUIRED )

def logClearCounters( name="", intf="" ):
   """Logs clear counters, adding user, console and remote host
   where CLI command was executed"""

   if name != "":
      name = name + " "

   if intf != "":
      intf = "on " + intf + " "

   info = UtmpDump.getUserInfo()
   Logging.log( CLEAR_COUNTERS, name, intf,
                info[ 'user' ], info[ 'tty' ], info[ 'ipAddr' ] )
