# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
import Tracing

t0 = Tracing.trace0

def createLocalEntities( em, types ):
   localDir = 'localAgentPlugin'
   em.root().parent.newEntity( 'Tac::Dir', localDir )
   em.localRootPathIs( em.sysname() + "/" + localDir )

   agentPluginContext = Tac.newInstance( "Agent::Plugin::Context" )
   agentPluginLoader = Tac.newInstance( "Agent::Plugin::Loader" )
   pluginGroup = "IntfCollections"

   # Create a dummy parent mountGroup before loading agentPlugins just like
   # an Agent would invoke it.
   testMg = em.mountGroup()
   pathEntDict = {}
   for path, entType in types:
      pathEntDict[ path ] = em.createLocalEntity( path, entType )

   agentPluginContext.entityManager = em.cEntityManager()
   agentPluginLoader.loadPluginGroup( 'AgentPlugin', pluginGroup,
                                      agentPluginContext, "", "" )

   def _finishMounts():
      t0( "Local entities created" )

   testMg.close( _finishMounts )
   return pathEntDict
