#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import SharedMem
import Smash
import Tac
import Tracing

t0 = Tracing.trace0
t2 = Tracing.trace2

IgmpProxyStatus = Tac.Type( "Irb::Multicast::IgmpProxyStatus" )

def Plugin( ctx ):
   pluginCtx = ctx

   mg = ctx.entityManager().mountGroup()
   shmemEm = SharedMem.entityManager( sysdbEm=ctx.entityManager() )

   # pkgdeps: rpm McastVpn-lib
   vxlanInfo = Tac.newInstance( "Bridging::IgmpSnooping::VxlanInfoWithSms" )
   t2( 'Setting vxlan Info' )
   pluginCtx.vxlanInfoIs( vxlanInfo )

   evpnDynamicVlanStatus = mg.mount( 'bridging/input/dynvlan/vlan/evpn',
                                     'Bridging::Input::VlanIdSet', 'r' )
   igmpProtocolStatus = mg.mount( 'bridging/igmpsnooping/protocol/status',
                                  'Bridging::IgmpSnooping::IgmpProtocolStatus', 'w' )
   igmpProxyStatus = shmemEm.doMount( IgmpProxyStatus.mountPath,
                                      "Irb::Multicast::IgmpProxyStatus",
                                      Smash.mountInfo( 'shadow' ) )
# Future mut. Project is put on hold
# we don't want to unnecessarily mount.
#  hwConfig = mg.mount( 'bridging/igmpsnooping/hardware/config',
#                       'Bridging::IgmpSnooping::HwConfig', 'r' )
#
#  vtiStatusDir = mg.mount( 'interface/status/eth/vxlan',
#                           'Vxlan::VtiStatusDir',
#                           'r' )
#  mcastVxlanStatus = mg.mount( 'routing/multicast/vxlan/status',
#                               'Routing::Multicast::Vxlan::Status', 'r' )

   def finishMounts():
      t2( 'Vxlan Snooping: Mounts complete ' )

# Future mut. Project is put on hold.
# We don't want to unnecessarily start SM.
#AddressFamily = Tac.Type( "Arnet::AddressFamily" )
#     enableSm = Tac.newInstance(
#        "Bridging::IgmpSnooping::VxlanSnoopingEnableSm",
#        AddressFamily.ipv4,
#        hwConfig,
#        vtiStatusDir,
#        mcastVxlanStatus,
#        vxlanInfo.swForwarderColl )

      # pkgdeps: library VxlanSnooping
      dynamicVlanSm = Tac.newInstance( "Bridging::IgmpSnooping::DynamicVlanSm",
            evpnDynamicVlanStatus, igmpProtocolStatus )

      # pkgdeps: library VxlanSnooping
      igmpProxyEnabledSm = Tac.newInstance(
            "Bridging::IgmpSnooping::IgmpProxyEnabledSm",
            igmpProxyStatus, evpnDynamicVlanStatus, igmpProtocolStatus )
#
#     vxlanInfo.enableSm = enableSm
      vxlanInfo.dynamicVlanSm = dynamicVlanSm
      vxlanInfo.igmpProxyEnabledSm = igmpProxyEnabledSm

   mg.close( finishMounts )

