#!/usr/bin/env python
# Copyright (c) 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

"""
This module contains the common helper methods for IgmpSnooping.
"""

def isVlanActive( bridgingInputCli, vlanId ):
   """Check if the vlan is configured and active.
      bridgingInputCli points to bridging/input/config/cli in sysdb"""
   vlan = bridgingInputCli.vlanConfig.get( vlanId )
   if vlan and vlan.adminState == 'active':
      return True
   return False

def activeVlans( bridgingInputCli ):
   """Returns a list of all configured and active vlans.
      bridgingInputCli points to bridging/input/config/cli in sysdb"""
   vlanList = bridgingInputCli.vlanConfig
   vlanIds = [ v for v in vlanList if isVlanActive( bridgingInputCli, v ) ]
   vlanIds.sort( key=int  )
   return vlanIds

def agentName():
   ''' Returns the agent name. Call this if and only if the intention
   is to run the agent locally. The call enables the static analyzer
   to generate the correct RPM dependencies. '''
   return 'IgmpSnooping'
