# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

'''This module defines all types, enums, etc... related with defining logical SerDes
mappings on HW L1 components.
'''

from __future__ import absolute_import, division, print_function

from collections import namedtuple

import Tac

MappingDesc = namedtuple( 'MappingDesc', [ 'sysMode', 'sysSerdes', 'lineMode',
                                           'lineSerdes' ] )

EthFecEncoding = Tac.Type( 'Interface::EthFecEncoding' )
FEC_RS528 = EthFecEncoding.fecEncodingReedSolomon
FEC_RS544 = EthFecEncoding.fecEncodingReedSolomon544
FEC_FCFEC = EthFecEncoding.fecEncodingFireCode
FEC_NOFEC = EthFecEncoding.fecEncodingDisabled

EthLaneCount = Tac.Type( 'Interface::EthLaneCount' )
LANE_COUNT_1 = EthLaneCount.laneCount1
LANE_COUNT_2 = EthLaneCount.laneCount2
LANE_COUNT_4 = EthLaneCount.laneCount4
LANE_COUNT_8 = EthLaneCount.laneCount8
LANE_COUNT_10 = EthLaneCount.laneCount10

EthSpeed = Tac.Type( 'Interface::EthSpeed' )
SPEED_GBPS_400 = EthSpeed.speed400Gbps
SPEED_GBPS_200 = EthSpeed.speed200Gbps
SPEED_GBPS_100 = EthSpeed.speed100Gbps
SPEED_GBPS_50 = EthSpeed.speed50Gbps
SPEED_GBPS_40 = EthSpeed.speed40Gbps
SPEED_GBPS_25 = EthSpeed.speed25Gbps
SPEED_GBPS_10 = EthSpeed.speed10Gbps
SPEED_GBPS_5 = EthSpeed.speed5Gbps
SPEED_GBPS_2p5 = EthSpeed.speed2p5Gbps
SPEED_GBPS_1 = EthSpeed.speed1Gbps
SPEED_MBPS_100 = EthSpeed.speed100Mbps
SPEED_MBPS_10 = EthSpeed.speed10Mbps

UNKNOWN_SERDES_GROUP_ID = Tac.Value( 'Hardware::L1Topology::SerdesGroupId' )

SerdesGroupMode = Tac.Type( 'Hardware::Phy::SerdesGroupMode' )
G400_8_RS544 = SerdesGroupMode( SPEED_GBPS_400, FEC_RS544, LANE_COUNT_8 )
G200_4_RS544 = SerdesGroupMode( SPEED_GBPS_200, FEC_RS544, LANE_COUNT_4 )
G100_2_RS544 = SerdesGroupMode( SPEED_GBPS_100, FEC_RS544, LANE_COUNT_2 )
G100_4_RS528 = SerdesGroupMode( SPEED_GBPS_100, FEC_RS528, LANE_COUNT_4 )
G100_4_NOFEC = SerdesGroupMode( SPEED_GBPS_100, FEC_NOFEC, LANE_COUNT_4 )
G50_1_RS544 = SerdesGroupMode( SPEED_GBPS_50, FEC_RS544, LANE_COUNT_1 )
G50_2_RS528 = SerdesGroupMode( SPEED_GBPS_50, FEC_RS528, LANE_COUNT_2 )
G50_2_FCFEC = SerdesGroupMode( SPEED_GBPS_50, FEC_FCFEC, LANE_COUNT_2 )
G50_2_NOFEC = SerdesGroupMode( SPEED_GBPS_50, FEC_NOFEC, LANE_COUNT_2 )
G40_4_NOFEC = SerdesGroupMode( SPEED_GBPS_40, FEC_NOFEC, LANE_COUNT_4 )
G40_2_NOFEC = SerdesGroupMode( SPEED_GBPS_40, FEC_NOFEC, LANE_COUNT_2 )
G25_1_RS528 = SerdesGroupMode( SPEED_GBPS_25, FEC_RS528, LANE_COUNT_1 )
G25_1_FCFEC = SerdesGroupMode( SPEED_GBPS_25, FEC_FCFEC, LANE_COUNT_1 )
G25_1_NOFEC = SerdesGroupMode( SPEED_GBPS_25, FEC_NOFEC, LANE_COUNT_1 )
G10_1_NOFEC = SerdesGroupMode( SPEED_GBPS_10, FEC_NOFEC, LANE_COUNT_1 )
G5_1_NOFEC = SerdesGroupMode( SPEED_GBPS_5, FEC_NOFEC, LANE_COUNT_1 )
G2P5_1_NOFEC = SerdesGroupMode( SPEED_GBPS_2p5, FEC_NOFEC, LANE_COUNT_1 )
G1_1_NOFEC = SerdesGroupMode( SPEED_GBPS_1, FEC_NOFEC, LANE_COUNT_1 )
M100_1_NOFEC = SerdesGroupMode( SPEED_MBPS_100, FEC_NOFEC, LANE_COUNT_1 )
M10_1_NOFEC = SerdesGroupMode( SPEED_MBPS_10, FEC_NOFEC, LANE_COUNT_1 )
