# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import HttpService
import Tracing

class Mcs( HttpService.HttpServiceConfig ):
   Tracing.trace1( "Class MCS HttpService Plugin" )
   def externalServerConfig( self, vrf ):
      Tracing.trace1( "Getting externalServerConfig MCS HttpService Plugin" )
      return """
       location ^~ /mcs {{
          include uwsgi_params;
          uwsgi_param  SSL_CLIENT_VERIFY  $ssl_client_verify;
          uwsgi_param  SSL_CLIENT_S_DN    $ssl_client_s_dn_legacy;
          uwsgi_param  SERVER_ADDR        $server_addr;
          uwsgi_param  VRF_NAME           {vrfName};
          uwsgi_read_timeout 60m;
          uwsgi_send_timeout 60m;
          uwsgi_pass unix:///var/run/mcs.uwsgi.sock;
          uwsgi_intercept_errors on;
          error_page 444 @drop;
      }}""".format( vrfName=vrf )

Tracing.trace1( "Invoking MCS HttpService Plugin" )
def Plugin( ctx ):
   # pylint: disable-msg=no-value-for-parameter
   Tracing.trace1( "Registering MCS HttpService Plugin" )
   ctx.registerService( Mcs( ctx, "mcs" ) )
