# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from IpLibConsts import DEFAULT_VRF
import HttpService
import CapiConstants
import ExternalServicesConstants

class ExternalServices( HttpService.HttpServiceConfig ):
   def serviceEnabled( self, vrf ):
      enabled = False
      errorMsg = ''
      serviceEnabled = ( self.service in self.serverConfig.service and
                         self.serverConfig.service[ self.service ].enabled )
      configuredVrfs = []
      for v, config in self.serverConfig.vrfConfig.items():
         if self.service in config.vrfService:
            configuredVrfs.append( v )

      # check if external-services is enabled in VRF specifically
      if serviceEnabled:
         # check if external-services is enabled in VRF 
         # or external-services enabled with no VRF configuration
         enabled = ( ( vrf == DEFAULT_VRF and not configuredVrfs ) or
                     ( vrf in configuredVrfs and
                       self.serverConfig.vrfConfig[ vrf ].vrfService[ self.service ]
                     ) )
      # check if external-services is enabled in VRF implicitly
      else:
         # check if external-services is disabled with no VRF configuration 
         # and Capi is enabeld in VRF
         enabled = ( not configuredVrfs and
                     HttpService.checkServiceEnabled( self.serverConfig,
                                                      CapiConstants.SERVICE_NAME,
                                                      vrf ) )
         if vrf in configuredVrfs:
            errorMsg = ExternalServicesConstants.SERVICE_ERROR % vrf
      
      # update external-services warning message
      if vrf in self.serverStatus.vrfStatus:
         self.serverStatus.vrfStatus[ vrf ].vrfError[ self.service ] = errorMsg
      return enabled

   def externalServerConfig( self, vrf ): 
      return """include external_conf/*.conf;"""

   def virtualServerConfig( self ):
      return """    include conf.d/*.conf;"""

def Plugin( ctx ):
   ctx.registerService( ExternalServices( ctx, 
                                          ExternalServicesConstants.SERVICE_NAME ) )
