#!/usr/bin/env python
# Copyright (c) 2012 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from collections import OrderedDict
from CliCommon import ResponseFormats # pylint: disable-msg=W0611
from OpenSslRFCNames import OPENSSL_TO_RFC_NAMES

class ServerConstants( object ):
   """ General constants for the HTTP server. """
   
   # CORS constants
   ALLOW_ALL_CROSS_ORIGIN_DOMAINS = "all"
   ALLOW_ALL_CROSS_ORIGIN_DOMAINS_STAR = "*"
   CORS_PREFLIGHT_CACHE_TIME = 600
   CORS_EXPOSE_HEADERS = ( "Cache-control", "Pragma", "Location", "WWW-Authenticate",
                          "Content-type", "Content-length", "Connection" )
   CORS_ALLOW_HEADERS = ( "Authorization", "Content-Type", "Accept", "Origin",
                         "User-Agent", "DNT", "Cache-Control", "X-Mx-ReqToken",
                         "Keep-Alive", "X-Requested-With", "If-Modified-Since" )

   # NGINX constants
   NGINX_CONF_FILE = "/etc/nginx/nginx.conf"
   NGINX_STATUS_URL = "http://localhost:50000/nginx_status"
   NGINX_LOG_FILE = "/var/log/nginx-access.log"
   NGINX_ERROR_LOG_FILE = "/var/log/nginx-error.log"

   # SSL/TLS constants
   BASE_SSL_FILE_DIR = "/persist/secure/"
   SSL_CERT_FILE = "capi.pem"
   SSL_KEY_FILE = "capikey.pem"
   SSL_CERT_DAYS = 30000

   # Server Error Messages
   CAPI_VRF_ERROR = 'VRF %r is either not defined or not active.'
   INVALID_SSL_KEY = 'SSL key error: Invalid Private Key'
   INVALID_SSL_CERT = 'SSL certificate error: Invalid Certificate'
   INVALID_SSL_CERT_KEY = ( 'SSL certificate/key error: Certificate and Private '
                            'Key do not match' )
   SERVICE_CMD_TIMEOUT = 60

   DEFAULT_TLS_PROTOCOLS = [ '1.0', '1.1', '1.2' ]

   serviceName = "httpServer"

class CapiCipherSuites( object ):
   CIPHERS = OrderedDict ( [
      ( "aes256-cbc",
         { "helpdesc" : "Advanced Encryption Standard (256 bit, CBC mode)",
           "filter" : "AES256" } ),
      ( "aes128-cbc",
         { "helpdesc" : "Advanced Encryption Standard (128 bit, CBC mode)",
           "filter" : "AES128" } )
   ] )

   KEYEXCHANGE = OrderedDict( [
      ( "rsa", { "helpdesc" : "RSA certificate", "filter" : "" } ),
      ( "diffie-hellman-ephemeral-rsa",
         { "helpdesc" : "Diffie Hellman paramers signed by RSA certificate",
           "filter" : "DHE-RSA" } )
   ] )

   MAC = OrderedDict( [
      ( "hmac-sha1",
         { "helpdesc" : "Hash Message Authentication Code SHA-1",
           "filter" : "SHA" } )
   ] )

   cipherSuiteFilterToNameMap = OPENSSL_TO_RFC_NAMES

   DEFAULT_CIPHERS = [ "AES256-SHA", "DHE-RSA-AES256-SHA", "AES128-SHA",
                       "DHE-RSA-AES128-SHA" ]
