# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac

class LogType():
   def __init__( self, helpPrefix, default):
      self.helpPrefix = helpPrefix
      self.default    = default

   def getSet( self, entity, levelVal ):
      attr = 'log' + self.helpPrefix

      if levelVal == None:
         # Note:  This only works in the save operator.  The CLI plugin itself
         # uses requires you to use __getattr__ here instead.
         return entity.__getattribute__( attr )

      entity.__setattr__( attr, levelVal )

defaults = Tac.Value( 'Hsc::CliDefaults' )

ovsdbLogTypes = { 'log-console' : LogType( 'Console', defaults.logConsole, ),
                  'log-syslog'  : LogType( 'Syslog',  defaults.logSyslog,  ),
                  'log-file'    : LogType( 'File',    defaults.logFile,    ), }

