#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import GrpcCounterLib
import Tracing

trace2 = Tracing.trace2

class PfcProvider( GrpcCounterLib.DataProvider ):

   COUNTER_TYPE = "PFC_SEND_RECEIVE_COUNTER"
   COMMAND_OPT = "priority-flow-control"

   def getCounters( self ):
      intfC = {}
      allEthIntfCounterDir = self.collector.allEthIntfCounterDir()
      for intf, counter in allEthIntfCounterDir.intfCounterDir.iteritems():
         currentCounter = counter.intfCounter.get( 'current', None )
         if currentCounter is None:
            continue
         numPriorities = len( currentCounter.outPfcClassFrames.count )
         trace2( 'Get pfc counters for: %s. %s priorities' %
                 ( intf, numPriorities ) )
         prioC = {}
         for p in xrange( numPriorities ):
            prioC[ str( p ) ] = {
               "rxFrames" : currentCounter.inPfcClassFrames.count.get( p, 0 ),
               "txFrames" : currentCounter.outPfcClassFrames.count.get( p, 0 )
            }
         intfC[ "%s" % intf ] = { "priorities" : prioC }

      trace2( 'pfc counter is %s' % intfC )
      return { "interfaces" : intfC }

def Plugin( context ):
   context.register( PfcProvider )
