#!/usr/bin/env python
# Copyright (c) 2013 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import os
import re

def prefdlReader():
   # Sfa should be the default because EOS can run as VM without
   # veos-config e.g. CVX
   sid = "Sfa"
   if os.path.isfile( "/mnt/flash/veos-config" ):
      veos_config = file( "/mnt/flash/veos-config" ).read()
      mode = re.search( "^[ \t]*MODE[ \t]*=[ \t]*.*", veos_config,
                        flags=re.MULTILINE )
      if mode is not None \
         and mode.group().split( "=" )[ 1 ].strip().lower() == "sfe":
         sid = "Sfe"
   # No prefdl for vEOS systems, return a quasi-valid looking one (it
   # won't be used, but genprefdl would at least not assert).
   return """Sku: vEOS
SerialNumber:
SID: %s
PCA: PCA000000000
HwRev: 01.00
HwApi: 01.00
MacAddrBase:
""" % sid

# context - object of class genprefdlPluginContext
def Plugin( context ):
   # Guard - Only run on supported platforms
   supportedPlatforms = [ 'veos' ]
   if context.platform() not in supportedPlatforms:
      return

   # Register reader function with genprefdl
   context.prefdlReaderIs( prefdlReader )
