#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

# ( SID, HwApiMajor ) -> Fdl
fdlMapTable = {
   ( 'Sfa', '01' ): [ 'Sfa' ],
   ( 'Sfe', '01' ): [ 'Sfe' ],
}

def Plugin( ctx ):

   def fdlMapTableFn( sid, baseAsy, hwApiMajorVersion, hwApiMinorVersion,
                      cpuSid=None, cpuHwApiMajorVersion=None,
                      cpuHwApiMinorVersion=None, configDict=None ):
      lookupKey = ( sid, hwApiMajorVersion )
      return fdlMapTable.get( lookupKey, None )

   ctx.registerFdlMap( fdlMapTableFn )
   if ctx.registerKeys:
      ctx.registerFdlKeys( [
         { 'group': 'VEosSku',
           'sid': k[ 0 ],
           'hwApiMajorVersion': k[ 1 ] }
         for k in fdlMapTable ] )
