#!/usr/bin/env python
# Copyright (c) 2009, 2010 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function
import Tac, types

class GenericReactor( Tac.Notifiee ):
   """ A prebuilt Tac.Notifiee subclass that can react to named
   attributes of any Entity. 'callback' must be a callable, and accept
   a notifier argument. If any of the attributes is a collection,
   'callback' must also take a key argument."""
   notifierTypeName = '*'
   def __init__( self, entity, attributes, callback, callBackNow=False ):
      Tac.Notifiee.__init__( self, entity )
      if type( callback ) is types.MethodType:
         self.callback_ = Tac.WeakBoundMethod( callback )
      elif type( callback ) is types.FunctionType:
         self.callback_ = callback
      else:
         raise TypeError( "callable argument is not a method or a function." )
      for a in attributes:
         self.registerHandler( a, self.callback_ )
      if callBackNow:
         self.callback_( self )
