#!/usr/bin/env python
# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.
import os, sys, optparse
import AsuPStore

class Manifest( object ):

   def __init__( self, out=sys.stdout ):
      self.out_ = out

   def genAsuPStoreSection( self, plugins=None, pluginPath=None ):
      self.out_.write( "# Asu PStore Feature Supported Keys\n" )
      self.out_.write( "pStoreFeatureKeysDict = " )
      supportedKeysDict = AsuPStore.getFeatureSupportedKeys( plugins, pluginPath )
      self.out_.write( str( supportedKeysDict ) )
      self.out_.write( "\n" )

   def genManifest( self, plugins=None, pluginPath=None ):
      '''Generate manifest to out object'''
      self.genAsuPStoreSection( plugins, pluginPath )

if __name__ == '__main__':
   # BUG17892 - The CTIME check prevents any plugins from getting
   # loaded in the temporary EOS rootfs created during
   # the build of EosImage. The issue is that the CTIME of the
   # file ends up being the time when the rpm was installed
   # in the temporary EOS rootfs (ie after the EosImage builds
   # started)
   if os.environ.get( "FWK_PLUGIN_CTIME_LIMIT" ):
      del os.environ[ "FWK_PLUGIN_CTIME_LIMIT" ]

   op = optparse.OptionParser( usage="usage: %prog [--pythondir <path>]" )
   op.add_option( "", "--pythondir", action="append", dest="pythonDir",
                  help="directory to look for AsuPStorePlugins" )
   opts, args = op.parse_args()
   asuPluginPath = None
   if opts.pythonDir:
      asuPluginPath = [ p + "/AsuPStorePlugin" for p in opts.pythonDir ]

   man = Manifest()
   man.genManifest( pluginPath=asuPluginPath )
