#!/usr/bin/env python
# Copyright (c) 2012 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac, Fru, Tracing

__defaultTraceHandle__ = Tracing.Handle( 'Xilinx' )

t0 = Tracing.trace0

class XilinxDriver( Fru.FruDriver ):

   requires = [ Fru.FruDriver.pciInit ]
   provides = []

   managedTypeName = "Inventory::XilinxPartialReconfig"
   managedApiRe = "$"

   def __init__( self, xil, parentMib, parentDriver, driverCtx ):
      """Initialize a Hardware::Fpga::Xilinx::PartialReconfigConfig from the fdl
      Inventory::XilinxPartialReconfig information."""

      Fru.FruDriver.__init__( self, xil, parentMib, parentDriver, driverCtx )
      t0( 'Creating a Fru driver for', xil.name )

      xilinxConfigCollection = driverCtx.sysdbRoot[ 'hardware' ][ 'fpga' ]\
          [ 'config' ][ 'xilinx' ]
      partialReconfigConfig = Fru.Dep( xilinxConfigCollection.partialReconfigConfig,
                                       xil ).newMember(
                                          xil.name,
                                          Fru.powerGenerationId( self.invEntity_ ) )

      partialReconfigConfig.dynamicImage = xil.dynamicImage
      partialReconfigConfig.staticImage = xil.staticImage

      partialReconfigConfig.ham = Fru.pciHotplugHam( xil.pciComponent, driverCtx,
                                                     filename="resource2" )

      partialReconfigConfig.reconfigUtil = 'xilinxreconfig'
      partialReconfigConfig.staticUpgradeUtil = 'xapp'
      partialReconfigConfig.i2cPinSwap = xil.i2cPinSwap
      partialReconfigConfig.numFaps = xil.numFaps

      partialReconfigConfig.fullResetPinName = xil.fullReset.systemName
      partialReconfigConfig.hwResetPinName = xil.hwReset.systemName

      assert partialReconfigConfig.fullResetPinName and \
             partialReconfigConfig.hwResetPinName, \
          "Fru plugins probably ran in wrong order"

      if xil.loadStaticDone:
         partialReconfigConfig.loadStaticDonePinName = xil.loadStaticDone.systemName

      xil.partialReconfigConfig = partialReconfigConfig

def Plugin( ctx ):
   ctx.registerDriver( XilinxDriver )

   # We know that all Sysdb plugins have run before this, so the
   # following mount paths have already been 
   # created, and I can mount them here.
   mg = ctx.entityManager.mountGroup()
   mg.mount( 'hardware/fpga/config/xilinx', 
             'Hardware::Xilinx::PartialReconfigConfigDir', 'wi' )
   mg.close( None )
