# Copyright (c) 2010-2012 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac, Fru

def createXcvrCtrlPaths( fruBase, ctx ):
   configDir = ctx.sysdbRoot[ 'hardware' ][ 'xcvrController' ][ 'config' ]
   cellId = fruBase.managingCellId
   sliceId = fruBase.sliceId
   if cellId:
      cellConfigDir = configDir.mkdir( 'cell' ).mkdir( str( cellId ) )
      cellConfigDir.newEntity( "Hardware::XcvrController::CellConfig",
                                            "config" )
   elif sliceId:
      sliceConfigDir = configDir.mkdir( 'slice' )
      linecardConfigDir = \
            sliceConfigDir.newEntity( "Tac::Dir", sliceId )
      linecardConfigDir.newEntity( "Hardware::XcvrController::CellConfig",
                                   "config" )
   else:
      assert 0

def addXcvr( name, fruBase, inv, xcvrInv, ctx, xcvrType, xcvrNames=None ):
   # add the to the system directory, the policy agent uses this to control
   # the led's properties
   configDir = ctx.sysdbRoot[ 'hardware' ][ 'xcvrController' ][ 'config' ]
   #TODO: once allConfig goes away replace this chunk of code with 
   # a call to createXcvrCtrlPaths
   allConfig = configDir.newEntity( "Hardware::XcvrController::AllConfigDir", "all" )
   cellId = fruBase.managingCellId
   sliceId = fruBase.sliceId
   if cellId:
      cellConfigDir = configDir.mkdir( 'cell' ).mkdir( str( cellId ) )
      realConfig = cellConfigDir.newEntity( "Hardware::XcvrController::CellConfig",
                                            "config" )
      xcvrConfigLocal = cellConfigDir.newEntity(
         "Hardware::XcvrController::AllConfigDir", "xcvrConfig" )
   elif sliceId:
      sliceConfigDir = configDir.mkdir( 'slice' )
      linecardConfigDir = \
            Fru.Dep( sliceConfigDir, xcvrInv ).newEntity( "Tac::Dir", sliceId )
      realConfig = Fru.Dep( linecardConfigDir, xcvrInv ).newEntity(
         "Hardware::XcvrController::CellConfig", "config" )
      xcvrConfigLocal = Fru.Dep( linecardConfigDir, xcvrInv ).newEntity(
         "Hardware::XcvrController::AllConfigDir", "xcvrConfig" )
   else:
      assert 0

   if xcvrType == 'sfpPlus':
      xcvrConfig = Fru.Dep(realConfig.sfpPlusControllerConfig, inv).newMember( name )
      # add the xcvrController to the all collection
      Fru.Dep(allConfig.sfpPlusControllerConfig, inv).addMember( xcvrConfig )
      Fru.Dep(xcvrConfigLocal.sfpPlusControllerConfig, inv).addMember( xcvrConfig )
   elif xcvrType == 'qsfpPlus':
      xcvrConfig = \
         Fru.Dep(realConfig.qsfpPlusControllerConfig, inv).newMember( name )
      # add the xcvrController to the all collection
      Fru.Dep(allConfig.qsfpPlusControllerConfig, inv).addMember( xcvrConfig )
      Fru.Dep(xcvrConfigLocal.qsfpPlusControllerConfig, inv).addMember( xcvrConfig )
      # copy the link index to port name mapping
      for intfName in xcvrInv.xcvrConnection:
         xcvrConfig.link[ xcvrInv.xcvrConnection[ intfName ].linkIndex ] = intfName
   elif xcvrType == 'mbo':
      xcvrConfig = Fru.Dep(realConfig.mboControllerConfig, inv).newMember( name )
      # add the xcvrController to the all collection
      Fru.Dep(allConfig.mboControllerConfig, inv).addMember( xcvrConfig )
      Fru.Dep(xcvrConfigLocal.mboControllerConfig, inv).addMember( xcvrConfig )
      # copy the link index to port name mapping
      for intfName in xcvrInv.xcvrConnection:
         xcvrConfig.link[ xcvrInv.xcvrConnection[ intfName ].linkIndex ] = intfName
      # List out the Xcvr's that are under the control of this controller
      assert xcvrNames, "MBO XcvrController %s does not specify any xcvrNames \
                         under its control." % name
      for xcvr in range( 0, len( xcvrNames ) ):
         xcvrConfig.xcvrName[ xcvr ] = xcvrNames[ xcvr ]
   elif xcvrType == 'cfp2':
      xcvrConfig = \
         Fru.Dep(realConfig.cfp2ControllerConfig, inv).newMember( name )
      # add the xcvrController to the all collection
      Fru.Dep(allConfig.cfp2ControllerConfig, inv).addMember( xcvrConfig )
      Fru.Dep(xcvrConfigLocal.cfp2ControllerConfig, inv).addMember( xcvrConfig )
      # copy the link index to port name mapping
      for intfName in xcvrInv.xcvrConnection:
         xcvrConfig.link[ xcvrInv.xcvrConnection[ intfName ].linkIndex ] = intfName
   elif xcvrType == 'rcx':
      if name not in realConfig.rcxGroupControllerConfig:
         xcvrConfig = \
            Fru.Dep(realConfig.rcxGroupControllerConfig, inv).newMember( name )
         # add the xcvrController to the all collection
         Fru.Dep(allConfig.rcxGroupControllerConfig, inv).addMember( xcvrConfig )
         Fru.Dep(xcvrConfigLocal.rcxGroupControllerConfig, inv).addMember(
               xcvrConfig )
      else:
         xcvrConfig = realConfig.rcxGroupControllerConfig[ name ]
      assert xcvrNames, "RCx XcvrController %s does not specify any xcvrNames \
                         as a group member." % name
      assert len( xcvrNames ) == 1
      # copy the link index to port name mapping
      # create RcxControllerStatus inside the RcxGroupControllerStatus
      index = int( xcvrNames[ 0 ].rsplit( '/', 1 )[ -1 ] ) - 1
      xcvrConfig.link[ index ] = xcvrNames[ 0 ]
   elif xcvrType in ( 'osfp', 'qsfpDd', 'qsfpCmis' ):
      xcvrConfig = \
         Fru.Dep(realConfig.osfpControllerConfig, inv).newMember( name )
      # add the xcvrController to the all collection
      Fru.Dep(allConfig.osfpControllerConfig, inv).addMember( xcvrConfig )
      Fru.Dep(xcvrConfigLocal.osfpControllerConfig, inv).addMember( xcvrConfig )
      # copy the link index to port name mapping
      for intfName in xcvrInv.xcvrConnection:
         xcvrConfig.link[ xcvrInv.xcvrConnection[ intfName ].linkIndex ] = intfName
   else:
      # we don't support any other transceiver type
      assert 0

   xcvrConfig.generationId = Fru.powerGenerationId( inv )
   # XXX: This is not a final solution as AllConfigDir will be deprecated.
   allConfig.generationId = Fru.powerGenerationId( inv )
   xcvrConfigLocal.generationId = Fru.powerGenerationId( inv )
   # populate sliceId
   if cellId:
      allConfig.sliceId = "FixedSystem"
   else:
      xcvrConfigLocal.sliceId = sliceId

   return xcvrConfig
   
