#!/usr/bin/python
# Copyright (c) 2006-2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from EthPort import EthIntfFactory, EthPortDirDriver

class VirtualEthIntfFactory( EthIntfFactory ):
   managedTypeName = "Inventory::VirtualEthPort"

class VirtualEthPortDirDriver( EthPortDirDriver ):
   managedTypeName = "Inventory::VirtualEthPortDir"
   managedApiRe = "$"

   @staticmethod
   def portLabel( p ):
      if p.subSubLabel != 0xffffffff:
         label = "%d/%d/%d" % ( p.label, p.subLabel, p.subSubLabel )
      elif p.subLabel != 0xffffffff:
         label = "%d/%d" % ( p.label, p.subLabel )
      else:
         label = "%d" % p.label
      return label

   def portName( self, fruEntMib, p ):
      tag = self.portNamePrefix( p )
      suffix = VirtualEthPortDirDriver.portLabel( p )
      if fruEntMib.tacType.fullTypeName == "EntityMib::Card":
         return '%s%s/%s' % ( tag, fruEntMib.relPos, suffix )
      elif fruEntMib.tacType.fullTypeName == "EntityMib::FixedSystem":
         return '%s%s' % ( tag, suffix )
      else:
         assert 0
         return None # unreachable

def Plugin( context ):
   context.registerDriver( VirtualEthPortDirDriver )
