# Copyright (c) 2015 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac, Fru, ArbusAgent

import Tracing
__defaultTraceHandle__ = Tracing.Handle( "Fru.SpiAccel" )
t4 = Tracing.trace4

class SpiAccelDriver( Fru.FruDriver ):

   managedTypeName = "Inventory::PciScd"
   primaryDriver = False

   def __init__( self, scd, parentMibEntity, parentDriver, driverCtx ):
      t4( "SpiAccelDriver:", scd )
      Fru.FruDriver.__init__( self, scd, parentMibEntity, 
                              parentDriver, driverCtx )

      if not scd.spiAccelBlock.keys():
         # Nothing to do
         return

      sysdbRoot = driverCtx.sysdbRoot
      fruBaseName = Fru.fruBaseName( scd )
      agentId = ArbusAgent.sliceIdToAgentId( fruBaseName )

      spiDirStr = 'spi'
      hwSpi = Fru.newStyleHardwareDir( sysdbRoot[ 'hardware' ][ spiDirStr ],
                                        'Hardware::Spi::Engine', scd )

      t4( "Wiring up the scd driver ham to ", scd.ham )

      for spiAccel in scd.spiAccelBlock.values():
         hwAccel = hwSpi.newAccel( spiAccel.id )
         hwAccel.ham = ( 'ham', 'hamTypeRecursive', scd.ham, spiAccel.offset, 0x30,
                         "" )
         spiAccel.hwSpiAccel = hwAccel

      hwSpi.agentId = agentId

def Plugin( context ):
   context.registerDriver( SpiAccelDriver )
   mg = context.entityManager.mountGroup()
   mg.mount( 'hardware/spi', 'Tac::Dir', 'wi' )
   mg.close( None )
