# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

# Pairs of incompatible PSUs - to add a new incompatibility, add a pair to this
# list. if several PSUs are incompatible, add one entry for each pair of 
# incompatibilities. i.e. if PSUs A, B, and C all do not work with each other, you
# would add the following entries: 
#
# ( A, B ),
# ( A, C ),
# ( B, C )
#
# You do not need to add the inverse relationship ( B, A ) - that gets calculated
# out in the psuIncompatibilityMap
psuIncompatibilities = [
      ( 'PWR-1900AC-F', 'PWR-2401-AC-RED' ),
      ( 'PWR-1900AC-R', 'PWR-2401-AC-BLUE' ),
      ]

# This map iterates out the incompatibility pairs to generate a list for each model
# of all the PSUs that particular model will be incompatible with. For example:
# [ (A,B), (A,C), (B,C) ] -> { A:[B,C], B:[A,B], C:[A,B] }
psuIncompatibilityMap = {}
def addIncompatibility( model1, model2 ):
   if not psuIncompatibilityMap.get( model1 ): 
      psuIncompatibilityMap[ model1 ] = [ model2 ]
   else:
      psuIncompatibilityMap[ model1 ].append( model2 )

for model, incompatModel in psuIncompatibilities:
   addIncompatibility( model, incompatModel )
   addIncompatibility( incompatModel, model )

def incompatibilityList( modelName ):
   return psuIncompatibilityMap.get( modelName )
