# Copyright (c) 2015 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Fru

class PlutoLibraryDriver( Fru.FruDriver ):
   managedTypeName = "Inventory::PlutoLibrary"
   provides = [ 'plutoLibraryInit' ]

   def __init__( self, plInv, parentMibEntity, parentDriver, driverCtx ):
      Fru.FruDriver.__init__( self, plInv, parentMibEntity, parentDriver,
                              driverCtx )
      sysdbRoot = driverCtx.sysdbRoot
      hwPlutoLibraryConfig = sysdbRoot[ 'hardware' ][ 'pluto' ][ 'library' ] \
                                      [ 'config' ]
      hwPlutoLibraryConfig.libPath = plInv.libPath
      hwPlutoLibraryConfig.devArgs = plInv.devArgs
      hwPlutoLibraryConfig.scdPresent = plInv.scdPresent
      hwPlutoLibraryConfig.isWhitebox = not plInv.scdPresent
      hwPlutoLibraryConfig.valid = True


def Plugin( context ):
   context.registerDriver( PlutoLibraryDriver )

   mg = context.entityManager.mountGroup()
   mg.mount( 'hardware/pluto/library/config',
             'Hardware::PlutoLibrary::Config', 'wi' )
   mg.close( None )
