#!/usr/bin/env python
# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac, Fru, Tracing
import Cell

__defaultTraceHandle__ = Tracing.Handle( 'PhyTopoFru' )

t0 = Tracing.trace0
t1 = Tracing.trace1

class PhyTraceTopoDriver( Fru.FruDriver ):

   managedTypeName = 'Inventory::L1TraceDir'
   managedApiRe = '$'

   provides = [ "PhyTraceTopo" ]
   requires = []

   def __init__( self, l1TraceTopo, fruEntMib, parentDriver, driverCtx ):
      Fru.FruDriver.__init__( self, l1TraceTopo, fruEntMib,
                              parentDriver, driverCtx )

      sliceId = Fru.fruBase( l1TraceTopo ).sliceId
      if not sliceId:
         assert Cell.cellType() == 'fixed'
         sliceId = "FixedSystem"

      t0( 'Handling Inventory::L1TraceDir for %s' % sliceId )

      l1TopoDir = driverCtx.entity( 'hardware/l1/topology' )

      # Populate L1 Topo traces.
      l1TopoSliceHelper = Tac.newInstance(
            'Hardware::L1Topology::SliceFruPluginHelper', l1TopoDir )
      for traceId, invTrace in l1TraceTopo.l1Trace.iteritems():
         topoTrace = l1TopoSliceHelper.addTrace( sliceId, traceId )
         topoTrace.polarity = invTrace.polarity

def Plugin( context ):
   '''Register the plugins.'''
   context.registerDriver( PhyTraceTopoDriver )

   mg = context.entityManager.mountGroup()
   mg.mount( 'hardware/l1/topology', 'Tac::Dir', 'wi' )
   mg.close( None )

