#!/usr/bin/env python
# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

'''
This is an optional FRU plugin that populates the Hardware L1 Topology config
structure.

This FRU plugin is primarily designed to allow products to selectively switch to
chassis L1 Topology SMs as part of the BUG507469 effort.
'''

import Fru, Tracing

__defaultTraceHandle__ = Tracing.Handle( 'PhyTopoFru' )

t0 = Tracing.trace0
t1 = Tracing.trace1

class PhyTopoConfigDriver( Fru.FruDriver ):
   managedTypeName = 'Inventory::L1TopologyConfig'
   managedApiRe = '$'

   provides = [ "PhyTopoConfig" ]
   requires = []

   def __init__( self, invL1TopologyConfig, fruEntMib, parentDriver, driverCtx ):
      Fru.FruDriver.__init__( self, invL1TopologyConfig, fruEntMib,
                              parentDriver, driverCtx )

      t0( 'Handling Inventory::L1TopologyConfig' )
      hwL1TopoConfig = driverCtx.entity( 'hardware/l1/topology/config' )

      hwL1TopoConfig.managementScope = invL1TopologyConfig.managementScope
      hwL1TopoConfig.switchSliceId = invL1TopologyConfig.switchSliceId

def Plugin( context ):
   '''Register the plugins.'''
   context.registerDriver( PhyTopoConfigDriver )

   mg = context.entityManager.mountGroup()
   mg.mount( 'hardware/l1/topology/config',
             'Hardware::L1Topology::L1TopologyConfig', 'wc' )
   mg.close( None )
