# Copyright (c) 2016 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Fru
import OnieVersionLib
import Tracing

__defaultTraceHandle__ = Tracing.Handle( "Fru.PLSystem" )
t0 = Tracing.trace0

class PLSystemDriver( Fru.FruDriver ):
   managedTypeName = "Inventory::PLSystem"

   def __init__( self, inv, parentEntityMib, parentDriver, driverCtx ):
      Fru.FruDriver.__init__( self, inv, parentEntityMib, parentDriver, driverCtx )

      sysdbRoot = driverCtx.sysdbRoot
      hwSystemConfig = sysdbRoot[ 'hardware' ][ 'pluto' ][ 'system' ][ 'config' ]
      hwSystemConfig.libPath = inv.libPath
      hwSystemConfig.devArgs = inv.devArgs

      for i, key in enumerate( [ "FixedSystem" ] ):
         hwSystemConfig.powerOffKeys[ i ] = key
         hwSystemConfig.powerCycleKeys[ i ] = key

      self.loadOnieInstallerVersion( onieStatus=sysdbRoot[ 'onie' ][ 'status' ] )

      hwSystemConfig.initialized = True

   def loadOnieInstallerVersion( self, onieStatus=None ):
      t0( "loading onie-installer into onie/status" )
      if onieStatus and not onieStatus.version:
         onieStatus.version = OnieVersionLib.onieVersion()

def Plugin( ctx ):
   ctx.registerDriver( PLSystemDriver )

   mg = ctx.entityManager.mountGroup()
   mg.mount( 'hardware/pluto/system/config', 'Hardware::PLSystem::Config', 'w' )
   mg.mount( 'onie/status', 'Onie::Status', 'w' )
   mg.close( None )
