#!/usr/bin/env python
# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac, Fru, Tracing, Cell

from HwL1TopologyComponentLib import Components

__defaultTraceHandle__ = Tracing.Handle( 'PhyTopoFru' )

t0 = Tracing.trace0
t1 = Tracing.trace1

class MidplanePositionDriver( Fru.FruDriver ):

   managedTypeName = 'Inventory::L1MidplanePositionDir'
   managedApiRe = '$'

   provides = [ "MidplanePositions" ]
   requires = []

   def __init__( self, l1MidplanePositions, fruEntMib, parentDriver, driverCtx ):
      Fru.FruDriver.__init__( self, l1MidplanePositions, fruEntMib,
                              parentDriver, driverCtx )

      sliceId = Fru.fruBase( l1MidplanePositions ).sliceId
      if not sliceId:
         assert Cell.cellType() == 'fixed'
         sliceId = "FixedSystem"

      t0( 'Handling Inventory::L1MidplanePositionDir for %s' % sliceId )

      l1TopoDir = driverCtx.entity( 'hardware/l1/topology' )

      # Populate L1 Topo traces.
      l1TopoMidplaneHelper = Tac.newInstance(
            'Hardware::L1Topology::MidplaneFruPluginHelper', l1TopoDir )
      PosType = Tac.Type( "PhyEee::MidplanePositionDescriptor" )
      ConnType = Tac.Type( "PhyEee::MidplaneConnectorDescriptor" )
      for midplanePos in l1MidplanePositions.position:
         pos = PosType( sliceId, midplanePos.position )
         componentClass = Components.getComponent( midplanePos.componentName )
         midplaneComp = componentClass( midplanePos.componentMode or None )
         conn = ConnType( sliceId, midplaneComp.getComponentType( 0 ),
                          midplanePos.componentId )
         # Add the position information into the MidplaneConnectorDir for the slice
         l1TopoMidplaneHelper.addPosition( pos, conn )

def Plugin( context ):
   '''Register the plugins.'''
   context.registerDriver( MidplanePositionDriver )

   mg = context.entityManager.mountGroup()
   mg.mount( 'hardware/l1/topology', 'Tac::Dir', 'wi' )
   mg.close( None )

