#!/usr/bin/env python
# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac, Fru, Tracing, Cell

__defaultTraceHandle__ = Tracing.Handle( 'PhyTopoFru' )

t0 = Tracing.trace0
t1 = Tracing.trace1

class MidplaneConnectionDriver( Fru.FruDriver ):

   managedTypeName = 'Inventory::L1MidplaneConnectionDir'
   managedApiRe = '$'

   provides = [ "MidplaneConnections" ]
   requires = []

   def __init__( self, l1MidplaneConnections, fruEntMib, parentDriver, driverCtx ):
      Fru.FruDriver.__init__( self, l1MidplaneConnections, fruEntMib,
                              parentDriver, driverCtx )

      sliceId = Fru.fruBase( l1MidplaneConnections ).sliceId
      if not sliceId:
         assert Cell.cellType() == 'fixed'
         sliceId = "FixedSystem"

      t0( 'Handling Inventory::L1MidplaneConnectionDir for %s' % sliceId )

      l1TopoDir = driverCtx.entity( 'hardware/l1/topology' )

      # Populate L1 Topo traces.
      l1TopoMidplaneHelper = Tac.newInstance(
            'Hardware::L1Topology::MidplaneFruPluginHelper', l1TopoDir )
      posType = Tac.Type( "PhyEee::MidplanePositionDescriptor" )
      for midplaneConn in l1MidplaneConnections.connection:
         sys = posType( midplaneConn.systemSlotId, midplaneConn.systemPosition )
         line = posType( midplaneConn.lineSlotId, midplaneConn.linePosition )
         l1TopoMidplaneHelper.addConnection( line, sys )
         l1TopoMidplaneHelper.addConnection( sys, line )

def Plugin( context ):
   '''Register the plugins.'''
   context.registerDriver( MidplaneConnectionDriver )

   mg = context.entityManager.mountGroup()
   mg.mount( 'hardware/l1/topology', 'Tac::Dir', 'wi' )
   mg.close( None )

