# Copyright (c) 2007, 2008, 2009, 2010 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac, Fru, ArbusAgent

import Tracing
__defaultTraceHandle__ = Tracing.Handle( "Fru.MdioAccel" )
t4 = Tracing.trace4

class MdioAccelDriver( Fru.FruDriver ):

   managedTypeName = "Inventory::PciScd"
   primaryDriver = False

   def __init__( self, scd, parentMibEntity, parentDriver, driverCtx ):
      t4( "MdioAccelDriver:", scd )
      Fru.FruDriver.__init__( self, scd, parentMibEntity, parentDriver, driverCtx )
      # BUG759: The ScdDriver FruPlugin needs to be instantiated first.

      if not scd.mdioAccelBlock.keys():
         # Nothing to do
         return

      sysdbRoot = driverCtx.sysdbRoot
      fruBaseName = Fru.fruBaseName( scd )
      agentId = ArbusAgent.sliceIdToAgentId( fruBaseName )

      managedMdio = scd.mdioAccelBlock.values()[ 0 ].managed
      mdioDirStr = 'mdio'

      if managedMdio:
         # If managed by something other than the MDIO agent, created under different
         # subdirectory.
         mdioDirStr = 'managedMdio'

      # Create the qualPath for slice agent
      hwMdio = Fru.newStyleHardwareDir( sysdbRoot[ 'hardware' ][ mdioDirStr ],
                                        'Hardware::Mdio::Engine',
                                        scd )

      # Note that we must set the ham before the mdio accelerators so
      # that it is serialized to an agent first
      t4( "Wiring up the scd driver ham to ", scd.ham )

      for mdioAccel in scd.mdioAccelBlock.values():
         assert mdioAccel.managed == managedMdio, \
                "All MDIO accelerators need to be managed homogonously."
         # get the interrupt controller (if present)
         intCtrl = None
         if mdioAccel.interruptController:
            intCtrl = mdioAccel.interruptController.fruIntCtrl
            assert intCtrl
         hwAccel = hwMdio.newAccel( mdioAccel.id,
                                    mdioAccel.offset,
                                    intCtrl )
         Fru.Dep( mdioAccel, mdioAccel ).hwMdioAgent = hwMdio
         hwAccel.busSpeed = mdioAccel.busSpeed
         hwAccel.ham = scd.ham
         for mdioBusSpeedBits in scd.mdioBusSpeedBits.itervalues():
            hwAccel.newBusSpeedBits( mdioBusSpeedBits.busSpeed,
                                     mdioBusSpeedBits.bitPattern )

      hwMdio.agentId = agentId
      hwMdio.ready = True

def Plugin( context ):
   context.registerDriver( MdioAccelDriver )

   mg = context.entityManager.mountGroup()
   mg.mount( 'hardware/mdio', 'Tac::Dir', 'wi' )
   mg.mount( 'hardware/managedMdio', 'Tac::Dir', 'wi' )
   mg.close( None )
